﻿//////////////////////////////////////////////
// RenderStrategy.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Entity ;
	class EntityRenderInfoSlot ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "Commands/RenderCommandQueue.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderStrategy
	{
		public :

			// Destructor
			virtual ~RenderStrategy () ;

			// Execution
			virtual RenderCommandQueue bakeRenderCommandQueue (Shader* shader, bool transparent) = 0 ;

			// Events
			virtual void updateAddRenderSlot (Entity* ent, const EntityRenderInfoSlot* slot) = 0 ;
			virtual void updateEraseRenderSlot (Entity* ent, const EntityRenderInfoSlot* slot) = 0 ;
	} ;
}